import java.io.*;
import java.util.regex.*;

public class Main {
  public static void main (String args[]) {
    if(args.length < 1){
      System.out.println("Wywołanie programu: Main katalog maska");
      return;
    }
    File file = new File(args[0]);
    String[] dirList;
    if(args.length < 2){
      dirList = file.list();
    }
    else{
      try{
        dirList = file.list((FilenameFilter) new MyFilenameFilter(args[1]));
      }
      catch(PatternSyntaxException e){
        System.out.println("Nieprawidłowe wyrażenie regularne: " + args[1]);
        return;
      }
    }
    for(int i = 0; i < dirList.length; i++){
      System.out.println(dirList[i]);
    }
  }
}

class MyFilenameFilter implements FilenameFilter {
  Pattern pattern;
  public MyFilenameFilter(String mask) {
    pattern = Pattern.compile(mask);
  }
  public boolean accept(File dir, String name) {
    Matcher matcher = pattern.matcher(name);
    return matcher.matches();
  }
}
